package jamezo97.clonecraft.recipe;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.ItemData;

import java.util.ArrayList;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeAddGenes implements IRecipe, IOnCrafted{
	
	public RecipeAddGenes(){
		CloneCraftCraftingHandler.add(this);
	}

	@Override
	public void onCrafted(EntityPlayer player, ItemStack result, IInventory ic) {
		ItemStack[] tubes = this.getTestTubes(ic);
		if(tubes != null){
			for(int a = 1; a < tubes.length; a++){
				ItemStack stackOld = tubes[a];
				if(stackOld != null && stackOld.getItem() == CloneCraft.instance.testTube){
					ItemStack stack = stackOld.copy();
					stack.stackSize = 1;
					stack.setItemDamage(0);
					ItemData data = new ItemData(stack);
					data.drain();
					data.save();
					if(!player.inventory.addItemStackToInventory(stack)){
						player.dropPlayerItem(stack);
					}
				}
			}
		}
	}

	@Override
	public boolean isValidItem(ItemStack stack, IInventory craftMatrix) {
		return false;
	}

	@Override
	public boolean matches(InventoryCrafting ic, World world) {
		ItemStack[] tubes = getTestTubes(ic);
		return tubes != null;
	}
	
	public ItemStack[] getTestTubes(IInventory ic){
		int size = ic.getSizeInventory();
		ArrayList<ItemStack> tubes = new ArrayList<ItemStack>();
//		ItemStack[] tubes = new ItemStack[2];
		for(int a = 0; a < size; a++){
			ItemStack stack = ic.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == CloneCraft.testTube.itemID){
					ItemData data = new ItemData(stack);
					if(data.containsGenes()){
						tubes.add(stack);
					}else{
						return null;
					}
				}else{
					return null;
				}
			}
		}
		return tubes.size() < 2?null:tubes.toArray(new ItemStack[tubes.size()]);
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting ic) {
		ItemStack[] tubes = getTestTubes(ic);
		if(tubes != null){
			ItemStack result = new ItemStack(CloneCraft.testTube, 1, 3);
			ItemData rData = new ItemData(tubes[0]);
			for(int a = 1; a < tubes.length; a++){
				ItemData t2Data = new ItemData(tubes[a]);
				for(int b = 0; b < t2Data.genes.length; b++){
					rData.setGene(t2Data.genes[b]);
				}
			}
			rData.save(result);
			return result;
		}
		return null;
	}

	@Override
	public int getRecipeSize() {
		return 0;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}

}
